function simPar = setupSimParameters(spacing)
    simPar = struct();

    simPar.N       = 32;                            % ULA array
    simPar.T       = 2;
    simPar.T_pre   = 5;
    simPar.fc      = 3.5e9;
    simPar.c       = 3e8;
    simPar.lambda  = simPar.c/simPar.fc;
    simPar.k0      = 2*pi/simPar.lambda;
    simPar.SNR_dB  = -1;
    simPar.Ts       = 0.75e-3;
    simPar.v       = 5;

    simPar.sigma2_n = 1/db2pow(simPar.SNR_dB);

    simPar.BS = struct();

    if ~exist('spacing', 'var')
        simPar.BS.spacing       = simPar.lambda/2;
    else
        simPar.BS.spacing       = spacing*simPar.lambda;
    end

    simPar.BS.antennaPos    = zeros(3, simPar.N);

    for idx = 1:simPar.N
        simPar.BS.antennaPos(:, idx) = ((idx-1) - (simPar.N-1)/2)*simPar.BS.spacing*[1;0;0];%阵列在x轴
    end

    simPar.x = zeros(4, simPar.N*simPar.T);                                      % Setup channel sampling points in 4-D spacetime.
%     simPar.x(2:4, :) = simPar.BS.spacing*[1;0;0]*(0:simPar.N-1);        % Coordinate convention: {ct, x, y, z}.
%     simPar.x(2:4, 1:simPar.N) = simPar.BS.spacing*[1;0;1]*position;
    simPar.x(2:4, 1:simPar.N) = simPar.BS.spacing*[1;0;0]*(0:simPar.N-1);
    
    simPar.x(1, 1:simPar.N) = zeros(1, simPar.N);                                                 %加入时间变量
    for idx = 1:simPar.T
    simPar.x(2:4, (idx-1)*simPar.N+1:idx*simPar.N) = simPar.BS.spacing*[1;0;0]*(0:simPar.N-1);
    simPar.x(1, (idx-1)*simPar.N+1:idx*simPar.N) = ones(1, simPar.N).*simPar.Ts.*simPar.c*(idx-1); 
    end
    simPar.p = zeros(3, simPar.N*simPar.T);
    simPar.p(2, :) = 1;                                                 % Setup antenna polarizations to y-direction.

    simPar.xb = zeros(4, simPar.N);                                      % Setup channel sampling points in 4-D spacetime.
%     simPar.x(2:4, :) = simPar.BS.spacing*[1;0;0]*(0:simPar.N-1);        % Coordinate convention: {ct, x, y, z}.
    simPar.xb(2:4, 1:simPar.N) = simPar.BS.spacing*[1;0;0]*(0:simPar.N-1);                                                %加入时间变量
    simPar.xb(1, 1:simPar.N) = ones(1, simPar.N).*simPar.Ts.*simPar.c.*simPar.T; 
    simPar.pb = zeros(3, simPar.N);
    simPar.pb(2, :) = 1;                                                 % Setup antenna polarizations to y-direction.

    simPar.xf = zeros(4, simPar.N);                                      % Setup channel sampling points in 4-D spacetime.
    for i = 1:simPar.T_pre
    simPar.xf(2:4, (i-1)*simPar.N+1:i*simPar.N) = simPar.BS.spacing*[1;0;0]*(0:simPar.N-1);                                                %加入时间变量，取什么比较合适
    simPar.xf(1, (i-1)*simPar.N+1:i*simPar.N) = ones(1, simPar.N).*simPar.Ts.*simPar.c.*(simPar.T+i-1); 
    end
    simPar.pf = zeros(3, simPar.N*simPar.T_pre);
    simPar.pf(2, :) = 1;

    % simPar.channel.genMethod = "NearField";      
    % simPar.channel.genMethod = "EM_Correlation"; 

    usePackage("AMP");
    usePackage("OMP");
    
%     simPar.channel.genMethod        = "VirtualChannel";
    simPar.channel.RicianFactor_dB  = 20;
    simPar.channel.numPaths         = 6; 
% %     simPar.channel.genMethod          = "NearField"; 
    simPar.channel.genMethod          = "CDL"; 
%     simPar.channel.genMethod          = "SV"; 
%     simPar.channel.genMethod          = "NearField_SV"; 
%     simPar.channel.genMethod          = "Ray_tracing";

    simPar.channelEstimator.AMP.lambda      = 1.3;  % lambda = 1.2 

    usePackage("GPR"); 
    simPar.channelEstimator.GPR.optimizer   = "Armijo-Goldstein"; 
    % simPar.channelEstimator.GPR.optimizer   = "GradientAscent"; 
    % simPar.channelEstimator.GPR.optimizer   = "Fletcher-Reeves"; 
    simPar.channelEstimator.GPR.N_iter      = 2; 
    
    simPar.channelEstimator.GPR.mixedKernel = false;
    simPar.channelEstimator.GPR.mixKernelNum = 15; 

    %AR parameters
%     simPar.sta = 400;
%     R = zeros(simPar.T,simPar.T);
%     DD = zeros(simPar.T+1,simPar.sta);
%     v = zeros(simPar.T,1);
%     simPar.a = zeros(simPar.N,simPar.T);
%     D = zeros(simPar.N,simPar.T+1,simPar.sta);
%     Num = zeros(simPar.T+1,simPar.sta);
% %    for idxs = 1:simPar.sta
% %        cdl_model = nrCDLChannel('ChannelFiltering', false);
% %         cdl_model.MaximumDopplerShift       = 2*simPar.v/simPar.lambda;
% %         cdl_model.UTDirectionOfTravel       = [0;0];
% %         cdl_model.CarrierFrequency          = simPar.fc;
% %         cdl_model.SampleRate                = 1/simPar.Ts;
% %         cdl_model.SampleDensity             = Inf;
% %         cdl_model.NumTimeSamples            = simPar.T+1;
% %         cdl_model.TransmitAntennaArray.Size = [simPar.N, 1, 1, 1, 1];   % [M N P Mg Ng]
% %         cdl_model.ReceiveAntennaArray.Size  = [1, 1, 1, 1, 1]; 
% %         cdl_model.Seed                      = randi(10000);
% %         [pathGains, ~] = cdl_model();
% %         for idx1 = 1:simPar.T+1
% %              h1(:,idx1) = reshape(sum(pathGains(idx1, :, :, :), 2), [simPar.N, 1]);
% %         end
% %         
% %         for idx2 = 1:simPar.T+1
% %             
% %            D(:,idx2,idxs) = h1(:,idx2);
% %            
% %         end
% % %         for idxD = 1:simPar.N
% % %             D(idxD,:,idx) = h1(idxD,:);
% % %         end
% % 
% % %         R = R+h1(:,1:simPar.T)'*h1(:,1:simPar.T);
% % %         v = v+h1(:,1:simPar.T)'*h1(:,simPar.T+1);
% %         
% %    end
% %     for idx = 1:simPar.N
% %     DD(:,:) = D(idx,:,:);
% %     RQ = DD*DD'/simPar.sta;
% %     R = RQ(1:simPar.T,1:simPar.T);
% %     v = flip(RQ((simPar.T+1),(1:(simPar.T))));
% %     v = v.';
% %     simPar.a(idx,:) = inv(R)*v/10;
% % %     simPar.a(idx,:) = R\v;
% %     end
%   
%         cdl_model = nrCDLChannel('ChannelFiltering', false);
%         cdl_model.MaximumDopplerShift       = 2*simPar.v/simPar.lambda;
%         cdl_model.UTDirectionOfTravel       = [0;0];
%         cdl_model.CarrierFrequency          = simPar.fc;
%         cdl_model.SampleRate                = 1/simPar.Ts;
%         cdl_model.SampleDensity             = Inf;
%         cdl_model.NumTimeSamples            = simPar.T+simPar.sta;
%         cdl_model.TransmitAntennaArray.Size = [simPar.N, 1, 1, 1, 1];   % [M N P Mg Ng]
%         cdl_model.ReceiveAntennaArray.Size  = [1, 1, 1, 1, 1]; 
%         cdl_model.Seed                      = randi(10000);
%         [pathGains, ~] = cdl_model();
%         for idx1 = 1:simPar.T+simPar.sta
%              h1(:,idx1) = reshape(sum(pathGains(idx1, :, :, :), 2), [simPar.N, 1]);
%         end
%         for j = 1:simPar.T+1
%         simPar.h((j-1)*simPar.N+1:j*simPar.N) = h1(simPar.sta+j-1);
%         end
%         for idx2 = 1:simPar.T+1
%             for idx3 = 1:simPar.sta
%            D(:,idx2,idx3) = h1(:,idx3+idx2-1);
%            Num(idx2,idx3) = idx3+idx2-1;
%             end
%         end
% %         for idxD = 1:simPar.N
% %             D(idxD,:,idx) = h1(idxD,:);
% %         end
% 
% %         R = R+h1(:,1:simPar.T)'*h1(:,1:simPar.T);
% %         v = v+h1(:,1:simPar.T)'*h1(:,simPar.T+1);
%         
%     
%     for idx = 1:simPar.N
%     DD(:,:) = D(idx,:,:);
%     RQ = DD*DD'/simPar.sta;
%     R = RQ(1:simPar.T,1:simPar.T)+eye(simPar.T)*0.01;
%     v = flip(RQ((simPar.T+1),(1:(simPar.T))));
%     v = v.';
% %     [V,D2,W] = eig(R)
%     simPar.a(idx,:) = inv(R)*v;
% %     simPar.a(idx,:) = R\v;
%     end

%     simPar.R = R/simPar.sta;
%     simPar.va = v/simPar.sta;
%     simPar.a = pinv(simPar.R)*simPar.v;
% 

end
